% Model of a nonisothermal non-steady state CSTR

% Main file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

% data

clear all

tspan = 0:0.1:15;    % We want output every 0.1 h up to 10 s
cA0 = 2;             % Initial and incoming concentration of A (kmol/m3)
cB0 = 8;             % Initial concentration (kmol/m3)
cC0 = 0;             % Initial concentration (kmol/m3)

% k                  % Rate constant (m3/kmol/h)
A = 2.5e13;
EA = 100000;

V = 45;              % Reactor volume (m3)
Q = 15;              % Volumetrid flow rate (m3/h)
Tin = 328.15;        % Temperature of incoming liquid (K)

DH = -60000;         % Enthalpy of reaction at 25 C
CpA = 150;           % Heat capacity of A (kJ/kmol K)
CpB = 150;           % Heat capacity of B (kJ/kmol K)
CpC = 300;           % Heat capacity of C (kJ/kmol K)

c0(1) = cA0;         % Running variable for cA is C(:,1)
c0(2) = cB0;         % Running variable for cB is C(:,2)
c0(3) = cC0;         % Running variable for cC is C(:,3)
c0(4) = Tin;         % Running variable for T is C(:,4)

% Call of differential equation solver

options = odeset('RelTol', 1e-6, 'AbsTol', 1e-8, 'InitialStep', 0.01);
[T,C] = ode45(@f,tspan,c0,options,cA0,cB0,cC0,A,EA,V,Q,Tin,DH,CpA,CpB,CpC);

% Output

figure(1)
plot(T,C(:,1:3))
xlabel('Time (h)');
ylabel('Concentration (kmol/m3)');
figure(2)
plot(T,C(:,4))
xlabel('Time (h)');
ylabel('Temperature (K)');
T
C
[s1,s2] = size(T);

